<?php
require_once('GatewaySetting.php');
require_once('utility.php');
require_once('CommonUtility.class.php');

function check_new_esxi_sb_structure($argv)
{
    global $DTASCFG_XML_FILE;
    global $CLUSTER_DTASCFG_XML_FILE;

    $new_esxi_ip = $argv[0];
    $new_esxi_username = $argv[1];
    $new_esxi_password = $argv[2];
    //not use anymore, due to cannot get config by ms vm path, ms was shutdown.
    $new_esxi_ms_vmpath = $argv[3];

    $cfg_xml = simplexml_load_file($DTASCFG_XML_FILE);
    $ms_prefix = (string)$cfg_xml->management_server->prefix;
    $cluster_ms_vm_path = get_vm_vixpath($new_esxi_ip, $new_esxi_username, $new_esxi_password, $ms_prefix);
    $cluster_copy_cfg_info = array(
        'esxi_ip' => $new_esxi_ip,
        'esxi_username' => $new_esxi_username,
        'esxi_password' => $new_esxi_password,
        'ms_vmpath' => $cluster_ms_vm_path,
        'from' => $DTASCFG_XML_FILE,
        'to' => $CLUSTER_DTASCFG_XML_FILE,
    );
    copy_file_from_ms($cluster_copy_cfg_info);
    if (!file_exists($CLUSTER_DTASCFG_XML_FILE)) {
        $mask_cluster_copy_cfg_info = CommonUtility::mask_confidential_list($cluster_copy_cfg_info, array('esxi_username', 'esxi_password'));
        debug_print("Cannot copy cluster's dtascfg.xml. where cluster's info is " . var_export($mask_cluster_copy_cfg_info, true));
        exit(1);
    }

    debug_print("compare start");
    $sb_group_structure = new SandboxGroupStructureChecker($DTASCFG_XML_FILE, $CLUSTER_DTASCFG_XML_FILE);
    $nat_checker = new NATChecker($DTASCFG_XML_FILE, $CLUSTER_DTASCFG_XML_FILE);
    #unlink($CLUSTER_DTASCFG_XML_FILE);
    if(!isClusterInSwitchableSlaveMode($CLUSTER_DTASCFG_XML_FILE)) exit(1);
    if (!$sb_group_structure->isCompatible()) exit(2);
    if (!$nat_checker->isCompatible()) exit(3);
    debug_print("compare equal");
    exit(0);
}

function isClusterInSwitchableSlaveMode($cluster_cfg_path)
{
    $cluster_cfg = simplexml_load_file($cluster_cfg_path);
    $master_mode = (bool)(int)$cluster_cfg->cli->master;
    debug_print("is cluster in master mode: $master_mode");
    $is_switchable = (bool)(int)$cluster_cfg->cli->master_switchable;
    debug_print("is switchable: $is_switchable");
    return !$master_mode && $is_switchable;
}

class NATChecker
{
    protected $_master_gateway = null;
    protected $_cluster_gateway = null;

    public function __construct($master_cfg_path, $cluster_cfg_path)
    {
        try {
            $master_gateway_retriever = new GatewayRetriever($master_cfg_path, true);
            $this->_master_gateway = $master_gateway_retriever->getGateway();
            $slave_gateway_retriever = new GatewayRetriever($cluster_cfg_path);
            $this->_cluster_gateway = $slave_gateway_retriever->getGateway();
        } catch (Exception $e) {
            debug_print("Get exception while construct gateway: " . var_export($e, true));
            exit(1);
        }
    }

    public function isCompatible()
    {
        try {
            $ret = $this->_master_gateway->isCompatible($this->_cluster_gateway);
            if (!$ret) {
                debug_print("Gateway setting is not compatible");
                return false;
            }
        } catch (Exception $e) {
            debug_print("Get exception while compare gateway: " . var_export($e, true));
            return false;
        }
        return true;
    }
}

class SandboxGroupStructureChecker
{
    protected $_master_group_container = null;
    protected $_cluster_group_container = null;

    public function __construct($master_cfg_path, $cluster_cfg_path)
    {
        $master_cfg = simplexml_load_file($master_cfg_path);
        $cluster_cfg = simplexml_load_file($cluster_cfg_path);
        $this->_master_group_container = new SandboxGroupContainer($master_cfg->image_type);
        $this->_cluster_group_container = new SandboxGroupContainer($cluster_cfg->image_type);

    }

    public function isCompatible()
    {
        $ret = $this->_master_group_container->isCompatible($this->_cluster_group_container);
        if (!$ret) return false;
        return true;
    }
}

class SandboxInfo
{
    protected $_id = "";
    protected $_ip = "";
    protected $_status = "";

    public function __construct($id, $ip, $status)
    {
        $this->setId($id);
        $this->setIP($ip);
        $this->setStatus($status);
    }

    public function setId($id)
    {
        $this->_id = $id;
    }

    public function getId()
    {
        return $this->_id;
    }

    public function setIp($ip)
    {
        $this->_ip = $ip;
    }

    public function getIp()
    {
        return $this->_ip;
    }

    public function setStatus($status)
    {
        $this->_status = $status;

    }

    public function getStatus()
    {
        return $this->_status;
    }
}

class SandboxGroupContainer
{
    protected $_sandbox_group_list = array();

    public function getSandboxGroupList()
    {
        return $this->_sandbox_group_list;
    }

    public function __construct($sb_group_list_xml, $filter_out_inactive = true)
    {
        $this->setSBGroupList($sb_group_list_xml, $filter_out_inactive);
    }

    protected function setSBGroupList($sb_group_list_xml, $filter_out_inactive)
    {
        $find_sb_group_xpath = "./*[starts-with(name(),'image_')]";
        $sb_group_xml_list = $sb_group_list_xml->xpath($find_sb_group_xpath);
        foreach ($sb_group_xml_list as $sb_group_xml) {
            if ($filter_out_inactive && !(int)$sb_group_xml->isActive) continue;
            $sb_group = new SandboxGroupInfo($sb_group_xml);
            $this->_sandbox_group_list[] = $sb_group;
        }
    }

    public function sortSBGroupByStructureList()
    {
        @usort($this->_sandbox_group_list, array('SandboxGroupStructure', 'compareStructureByGroup'));
        return $this->getSandboxGroupList();
    }

    public function isCompatible($sandbox_group_container)
    {
        $sorted_sb_group_struc_list1 = $this->sortSBGroupByStructureList();
        $sorted_sb_group_struc_list2 = $sandbox_group_container->sortSBGroupByStructureList();
        debug_print("Compare struc1 is " . var_export($sorted_sb_group_struc_list1, true));
        debug_print("Compare struc2 is " . var_export($sorted_sb_group_struc_list2, true));
        if (count($sorted_sb_group_struc_list1) != count($sorted_sb_group_struc_list2)) {
            debug_print("count of sb group not equal");
            return false;
        }
        foreach ($sorted_sb_group_struc_list1 as $index => $sb_group1) {
            $sb_group1->getSbGroupStructure();
            $sb_group2 = $sorted_sb_group_struc_list2[$index];
            if (SandboxGroupStructure::compareStructureByGroup($sb_group1, $sb_group2) != 0) return false;
        }
        return true;
    }
}

class SandboxGroupStructure
{
    protected $_platform = "";
    protected $_sandbox_count = 0;
    protected $_sorted_applications_list = array();

    public function __construct($platform, $sb_count, $app_list)
    {
        $this->_platform = $platform;
        $this->_sandbox_count = $sb_count;
        $this->_sorted_applications_list = $app_list;
        sort($this->_sorted_applications_list);
    }

    public static function compareStructureByGroup($sb_group1, $sb_group2)
    {
        $sb_struc1 = $sb_group1->getSbGroupStructure();
        $sb_struc2 = $sb_group2->getSbGroupStructure();
        return SandboxGroupStructure::compareStructure($sb_struc1, $sb_struc2);
    }

    public static function compareStructure($sb_struc1, $sb_struc2)
    {
        $ret = strcmp($sb_struc1->getPlatform(), $sb_struc2->getPlatform());
        if ($ret != 0) {
            debug_print("Platform not equal");
            return $ret;
        }
        if ($sb_struc1->getSandboxCount() != $sb_struc2->getSandboxCount()) {
            debug_print("sandbox count not equal");
            return $sb_struc1->getSandboxCount() > $sb_struc2->getSandboxCount();
        }
        $sorted_app_list1 = $sb_struc1->getSortedApplicationsList();
        $sorted_app_list2 = $sb_struc2->getSortedApplicationsList();
        return SandboxGroupStructure::compareBySortedApplication($sorted_app_list1, $sorted_app_list2);
    }

    public static function compareBySortedApplication($sorted_app_list1, $sorted_app_list2)
    {
        if (count($sorted_app_list1) != count($sorted_app_list2)) {
            debug_print("app list count not equal");
            return count($sorted_app_list1) > count($sorted_app_list2);
        }
        foreach (array_combine($sorted_app_list1, $sorted_app_list2) as $app1 => $app2) {
            if ($app1 == $app2) continue;
            debug_print("$app1 and $app2 not equal");
            return strcmp($app1, $app2);
        }
        return 0;
    }

    public function getSortedApplicationsList()
    {
        return $this->_sorted_applications_list;
    }

    public function getPlatform()
    {
        return $this->_platform;
    }

    public function getSandboxCount()
    {
        return $this->_sandbox_count;
    }

}

class SandboxGroupInfo
{
    protected $_img_type = "";
    protected $_uuid = "";
    protected $_name = "";
    protected $_platform = "";
    protected $_update_time = "";
    protected $_application_list = array();
    protected $_sandbox_list = array();
    protected $_sb_group_struc = null;
    protected $_is_active = true;

    public function  __construct($sbgroup_xml)
    {
        $this->setImgType((string)$sbgroup_xml->type);
        $this->setUuid((string)$sbgroup_xml->image_type_uuid);
        $this->setName((string)$sbgroup_xml->name);
        $this->setPlatform((string)$sbgroup_xml->platform);
        $this->setUpdateTime((string)$sbgroup_xml->updatetime);
        //bool cast for SimpleXMLElement would be true if the tag exist, so cast to integer first
        $this->setIsActive((bool)(int)$sbgroup_xml->isActive);
        $this->setApplicationList($sbgroup_xml->applications);
        //not use for now
        $this->setSandboxList($sbgroup_xml->sandboxes);
        $this->_sb_group_struc = new SandboxGroupStructure($this->getPlatform(), $this->getSandboxCount(), $this->getApplicationList());
    }

    const SB_COUNT = 'sb_count';
    const PLATFORM = 'platform';
    const APPLICATIONS = 'applications';

    public function getSbGroupStructure()
    {
        return $this->_sb_group_struc;
    }

    public function getSandboxCount()
    {
        return count($this->_sandbox_list);
    }

    protected function setSandboxList($sandbox_xml)
    {
        $find_sandbox_xpath = "./*[starts-with(name(),'sandboxes_')]";
        $sandbox_xml_list = $sandbox_xml->xpath($find_sandbox_xpath);
        foreach ($sandbox_xml_list as $sandbox_xml) {
            $sb_id = (string)$sandbox_xml->ID;
            $sb_ip = (string)$sandbox_xml->IP;
            $sb_status = (string)$sandbox_xml->status;
            $sb_info = new SandboxInfo($sb_id, $sb_ip, $sb_status);
            $this->_sandbox_list[] = $sb_info;
        }
    }

    public function getApplicationList()
    {
        return $this->_application_list;
    }

    protected function setApplicationList($application_xml)
    {
        $find_application_xpath = "./*[starts-with(name(),'application_')]";
        $application_xml_list = $application_xml->xpath($find_application_xpath);
        foreach ($application_xml_list as $application_xml) {
            $app_name = (string)$application_xml;
            $this->_application_list[] = $app_name;
        }
    }

    public function setUuid($id)
    {
        $this->_uuid = $id;
    }

    public function getUuid()
    {
        return $this->_uuid;
    }

    public function setIsActive($is_active)
    {
        $this->_is_active = $is_active;
    }

    public function getIsActive()
    {
        return $this->_is_active;
    }


    public function setImgType($img_type)
    {
        $this->_img_type = $img_type;
    }

    public function getImgType()
    {
        return $this->_img_type;
    }

    public function setName($name)
    {
        $this->_name = $name;
    }

    public function getName()
    {
        return $this->_name;
    }

    public function setPlatform($platform)
    {
        $this->_platform = $platform;
    }

    public function getPlatform()
    {
        return $this->_platform;
    }

    public function getSandboxList()
    {
        return $this->_sandbox_list;
    }

    public function setUpdateTime($update_time)
    {
        $this->_update_time = $update_time;
    }

    public function getUpdateTime()
    {
        return $this->_update_time;
    }
}
